<?php

namespace MarvyElementor\animation;

if (!defined('ABSPATH')) exit;

use Elementor\Controls_Manager;

class MarvyParticlesWaveAnimation
{

    public function __construct()
    {
        add_action('elementor/frontend/section/before_render', array($this, 'before_render'), 1);
        add_action('elementor/element/section/section_layout/after_section_end', array($this, 'register_controls'), 1);
    }

    public function register_controls($element)
    {
        $element->start_controls_section('marvy_particles_wave_animation_section',
            [
                'label' => __('<div style="float: right"><img src="' . plugin_dir_url(__DIR__) . 'assets/images/logo.png" height="15px" width="15px" style="float:left;" alt=""></div> Particles Wave Animation', 'marvy-lang'),
                'tab' => Controls_Manager::TAB_LAYOUT
            ]
        );

        $element->add_control('marvy_enable_particles_wave_animation',
            [
                'label' => esc_html__('Enable Particles Wave Animation', 'marvy-lang'),
                'type' => Controls_Manager::SWITCHER
            ]
        );

        $element->add_control('marvy_enable_particles_wave_animation_default_background',
            [
                'label' => esc_html__('Use Default Background', 'marvy-lang'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'condition' => [
                    'marvy_enable_particles_wave_animation' => 'yes',
                ]
            ]
        );

        $element->add_control(
            'marvy_particles_wave_animation_particle_count',
            [
                'label' => esc_html__('Count', 'marvy-lang'),
                'type' => Controls_Manager::NUMBER,
                'default' => 600,
                'min' => 10,
                'condition' => [
                    'marvy_enable_particles_wave_animation' => 'yes',
                ]
            ]
        );

        $element->add_control(
            'marvy_particles_wave_animation_particle_size',
            [
                'label' => esc_html__('Size', 'marvy-lang'),
                'type' => Controls_Manager::NUMBER,
                'default' => 0.5,
                'min' => 0.1,
                'step' => 0.1,
                'max' => 20,
                'condition' => [
                    'marvy_enable_particles_wave_animation' => 'yes',
                ]
            ]
        );

        $element->add_control(
            'marvy_particles_wave_animation_animation_speed',
            [
                'label' => esc_html__('Delay', 'marvy-lang'),
                'type' => Controls_Manager::NUMBER,
                'default' => 200,
                'min' => 1,
                'condition' => [
                    'marvy_enable_particles_wave_animation' => 'yes',
                ]
            ]
        );

        $element->add_control(
            'marvy_particles_wave_animation_particle_color',
            [
                'label' => esc_html__('Color', 'marvy-lang'),
                'type' => Controls_Manager::COLOR,
                'default' => '#E8773F',
                'condition' => [
                    'marvy_enable_particles_wave_animation' => 'yes',
                ]
            ]
        );

        $element->end_controls_section();

    }

    public function before_render($element)
    {
        $settings = $element->get_settings();

        if ($settings['marvy_enable_particles_wave_animation'] === 'yes') {
            $element->add_render_attribute(
                '_wrapper',
                [
                    'data-marvy_enable_particles_wave_animation' => 'true',
                    'data-marvy_enable_particles_wave_animation_default_background' => $settings['marvy_enable_particles_wave_animation_default_background'],
                    'data-marvy_particles_wave_animation_particle_count' => $settings['marvy_particles_wave_animation_particle_count'],
                    'data-marvy_particles_wave_animation_particle_size' => $settings['marvy_particles_wave_animation_particle_size'],
                    'data-marvy_particles_wave_animation_animation_speed' => $settings['marvy_particles_wave_animation_animation_speed'],
                    'data-marvy_particles_wave_animation_particle_color' => $settings['marvy_particles_wave_animation_particle_color']
                ]
            );
        } else {
            $element->add_render_attribute('_wrapper', 'data-marvy_enable_particles_wave_animation', 'false');
        }
    }
}
